/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.admin.property.appspace;

import filenet.vw.api.VWRoleDefinition;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.admin.property.appspace.VWRoleAttributesTableModel;
import filenet.vw.toolkit.admin.resources.VWResource;
import filenet.vw.toolkit.utils.VWSessionInfo;
import filenet.vw.toolkit.utils.dialog.wizard.IVWWizardPanel;
import filenet.vw.toolkit.utils.table.VWFieldsCellEditor;
import filenet.vw.toolkit.utils.table.VWFieldsCellRenderer;
import filenet.vw.toolkit.utils.table.VWTable;
import filenet.vw.toolkit.utils.table.VWTableCellEditor;
import filenet.vw.toolkit.utils.table.VWTableCellRenderer;
import filenet.vw.toolkit.utils.uicontrols.border.IVWToolbarBorderActionListener;
import filenet.vw.toolkit.utils.uicontrols.border.VWToolbarBorder;
import filenet.vw.toolkit.utils.uicontrols.border.VWToolbarBorderActionEvent;
import filenet.vw.toolkit.utils.uicontrols.border.VWToolbarBorderClientActionEvent;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableColumn;

class VWRoleAttributesPanel
extends JPanel
implements IVWWizardPanel,
TableModelListener,
ListSelectionListener,
IVWToolbarBorderActionListener {
    private VWRoleDefinition m_roleDef = null;
    private VWToolbarBorder m_toolbarBorder = null;
    private VWRoleAttributesTableModel m_attributesTableModel = null;
    private VWTable m_attributesTable = null;

    public VWRoleAttributesPanel(VWSessionInfo sessionInfo) {
        this.createControls(sessionInfo);
        this.setEnabled(false);
    }

    public void setEnabled(boolean bEnabled) {
        int nButtonState = 2;
        int nButtons = Integer.MAX_VALUE;
        this.m_toolbarBorder.clientActionPerformed(new VWToolbarBorderClientActionEvent(this.m_toolbarBorder.getClientPanel(), nButtonState, nButtons));
        if (bEnabled) {
            nButtonState = 1;
            nButtons = 16;
            int nSelectedRow = this.m_attributesTable.getSelectedRow();
            if (nSelectedRow != -1) {
                if (nSelectedRow > 0) {
                    nButtons |= 1;
                }
                if (nSelectedRow < this.m_attributesTableModel.getRowCount() - 1) {
                    nButtons |= 2;
                }
                nButtons |= 0x10000000;
            }
            this.m_toolbarBorder.clientActionPerformed(new VWToolbarBorderClientActionEvent(this.m_toolbarBorder.getClientPanel(), nButtonState, nButtons));
        }
        this.m_attributesTable.setEnabled(bEnabled);
    }

    public void checkForErrors() throws Exception {
        this.stopEditing();
        if (this.m_roleDef == null) {
            return;
        }
    }

    public String getHelpTopic() {
        return "attributes";
    }

    public String getUniqueIdentifier() {
        return "ATTRIBUTES";
    }

    public String getInstructions() {
        return VWResource.AttributePanelInstructions;
    }

    public String getTitle() {
        return VWResource.AttributePanelTitle;
    }

    public void initialize() throws Exception {
    }

    public void releaseResources() {
        if (this.m_toolbarBorder != null) {
            this.m_toolbarBorder.addToolbarBorderActionNotifier(this);
            this.m_toolbarBorder.releaseReferences();
            this.m_toolbarBorder = null;
        }
        if (this.m_attributesTableModel != null) {
            this.m_attributesTableModel.releaseReferences();
            this.m_attributesTableModel = null;
        }
        if (this.m_attributesTable != null) {
            this.m_attributesTable.getSelectionModel().removeListSelectionListener(this);
            this.m_attributesTable.removeAll();
            this.m_attributesTable = null;
        }
        this.m_roleDef = null;
        this.removeAll();
    }

    public boolean getDisplayState() {
        return true;
    }

    public void setDisplayState(boolean bState) {
    }

    public boolean getEnableFinishButton() {
        return true;
    }

    public void tableChanged(TableModelEvent event) {
        try {
            switch (event.getType()) {
                case -1: 
                case 1: {
                    int nRowIndex = event.getLastRow() - 1;
                    if (nRowIndex < 0) {
                        nRowIndex = 0;
                    }
                    if (nRowIndex == this.m_attributesTable.getSelectedRow()) {
                        this.m_attributesTable.clearSelection();
                    }
                    this.m_attributesTable.setRowSelectionInterval(nRowIndex, nRowIndex);
                    break;
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void valueChanged(ListSelectionEvent event) {
        if (event.getValueIsAdjusting()) {
            return;
        }
        JPanel source = this.m_toolbarBorder.getClientPanel();
        this.m_toolbarBorder.clientActionPerformed(new VWToolbarBorderClientActionEvent(source, 2, 0x10000000));
        int nRowindex = this.m_attributesTable.getSelectedRow();
        if (this.m_attributesTableModel != null && nRowindex != -1 && nRowindex != this.m_attributesTableModel.getRowCount() - 1) {
            this.m_toolbarBorder.clientActionPerformed(new VWToolbarBorderClientActionEvent(source, 1, 0x10000000));
        }
    }

    public void toolbarBorderActionPerformed(VWToolbarBorderActionEvent event) {
        if (this.m_attributesTable == null || this.m_attributesTableModel == null) {
            return;
        }
        switch (event.getID()) {
            case 0x10000000: {
                this.m_attributesTableModel.deleteItem(this.m_attributesTable.getSelectedRow());
            }
        }
    }

    protected void setRoleDefinition(VWRoleDefinition roleDef) {
        try {
            this.m_roleDef = roleDef;
            if (this.m_roleDef == null) {
                this.setEnabled(false);
            } else {
                this.setEnabled(true);
                this.stopEditing();
                this.m_attributesTableModel.setSelectedRole(this.m_roleDef);
                if (this.m_attributesTableModel.getRowCount() > 0) {
                    this.m_attributesTable.setRowSelectionInterval(0, 0);
                } else {
                    JPanel source = this.m_toolbarBorder.getClientPanel();
                    this.m_toolbarBorder.clientActionPerformed(new VWToolbarBorderClientActionEvent(source, 2, 0x10000000));
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    protected boolean isModified() {
        this.stopEditing();
        if (this.m_attributesTableModel != null) {
            return this.m_attributesTableModel.isModified();
        }
        return false;
    }

    protected void resetModifiedFlag() {
        if (this.m_attributesTableModel != null) {
            this.m_attributesTableModel.resetModifiedFlag();
        }
    }

    protected void stopEditing() {
        if (this.m_attributesTable != null) {
            this.m_attributesTable.stopEditing();
        }
    }

    private void createControls(VWSessionInfo sessionInfo) {
        try {
            this.setLayout(new BorderLayout());
            this.setBorder(BorderFactory.createEmptyBorder(5, 10, 7, 10));
            this.m_toolbarBorder = new VWToolbarBorder(this.getTitle(), 0x10000000, this.getInstructions());
            this.m_toolbarBorder.setToolbarBackground(this.getBackground());
            this.m_toolbarBorder.addToolbarBorderActionNotifier(this);
            this.add((Component)this.m_toolbarBorder, "Center");
            JPanel clientPanel = this.m_toolbarBorder.getClientPanel();
            clientPanel.setLayout(new BorderLayout());
            this.m_attributesTableModel = new VWRoleAttributesTableModel(sessionInfo);
            this.m_attributesTableModel.addTableModelListener(this);
            this.m_attributesTable = new VWTable(this.m_attributesTableModel);
            this.m_attributesTable.setDefaultRenderer(String.class, new VWTableCellRenderer());
            this.m_attributesTable.setDefaultEditor(String.class, new VWTableCellEditor(new JTextField()));
            this.m_attributesTable.setName("m_attributesTable_VWAttributesPanel");
            this.m_attributesTable.getSelectionModel().addListSelectionListener(this);
            this.m_attributesTable.getSelectionModel().setSelectionMode(0);
            TableColumn tcElement = this.m_attributesTable.getColumnModel().getColumn(1);
            if (tcElement != null) {
                tcElement.setCellEditor(new DefaultCellEditor(this.m_attributesTableModel.getFieldTypeComboBox()));
                tcElement.setCellRenderer(new VWFieldsCellRenderer());
            }
            if ((tcElement = this.m_attributesTable.getColumnModel().getColumn(2)) != null) {
                tcElement.setCellEditor(new VWFieldsCellEditor(sessionInfo.getParentFrame(), false));
                tcElement.setCellRenderer(new VWFieldsCellRenderer());
            }
            clientPanel.add((Component)new JScrollPane(this.m_attributesTable), "Center");
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }
}

